        INTRO.4TH      (Advantages of Forth)

    Preface:

The purpose of this file is not just to tell you "Forth is Great", but rather
to clarify just what advantages Forth has over other languages, and to
communicate the "feel" of Forth in relation to programming tasks.

I hope it does that job well enough to give you a sense of the possibilities,
so that, when you pursue your desire to see for yourself what you can
accomplish with it, you will be expecting to create elegance.  And if you are
intent, you will be gratified.

Please read this without bias, and if you doubt any statements made, the author
is prepared to provide proof or acceptable evidence, or upload a corrected
version of this file.

If, on the other hand, you are not willing to find out that there is a
programming language considerably more capable and elegant than others you are
familiar with, then better to not even give it a single quick scan!  (grin)

                                                    Giles


    Topic Headings

Abreviation Definitions
Commands That Fit
Programming Environment
Personal Experience
What is Forth?
Different Installations
Examples
Small Concept= Large Capability
Grand Scale Programming
Use
My plans
Your application
Availability on CIS
Learning Forth
Social Aspects
Problems


    Abreviation Definitions

hdw., Hardware
OS, Operating System
PD, Public Domain
sfw., software


    Commands That Fit

  Have you ever wished:

1. A particular command went about things just a little differently?

2. A particular command behaved consistantly, rather than doing the wrong thing
   at just the wrong time?

3. You had a particular command, that would make things SOOooooo simple?

In Forth, the process of finding the code of a command and installing a
rewritten version is trivial.


    Programming Environment

Have you ever felt that programming would always be a pleasant experience, if
only You never had to program around bad system software?

  Have you ever wished:

1. You could program twice as fast?  ..Five times as fast?  ..TEN times as
   fast?!  And that you could debug the program as you write it, so that
   (generally) when you finished writing a module you wouldn't have to come
   back to it?
   (Forth often takes on the order of a hundredth the time equivalent programs
   can be coded in assembler. It also happens often enough, that assembler
   takes MORE than 100 times as long and the program STILL won't work
   satisfactorily. (grin)

2. That all the clever little subroutines you've worked out were instantly
   available, without having to look for them, or take any special pains to
   integrate them into the present program.

3. That calling a subroutine required nothing more than naming it?

4. That someway your programming environment would help you keep track of where
   you are, and how the routine you are working on now will affect other
   routines, or which ones will be affected?

5. That you could change the way your compiler behaves?  Or that you could add
   the ability to handle special cases without changing anything else?

6. That you could use hi-level commands, and a magic genie would come along and
   convert them to efficient machine code?  Or maybe just the ones needing
   speed, and leaving the others in the most compact form to save memory?

7. That you never had to worry about linking library routines, or that ONE copy
   of routines would suffice for ALL processes?

8. That you could have a multitasking, multiuser operating system with all the
   features of, say for instance, OS9 or Unix, but ALSO have the immediate
   utility of a powerful toolbox and programming language combined?

9. That you could bring the same, familiar environment and applications from
   obsolete hardware to new hardware with expanded capabilites, and easily add
   features to take advantage of the new hardware without having to change much
   if any of what you already have?  Examples:  Transfer your system and
   applications to a Tandy Color Computer in order to have graphics that beat
   some MS-DOS and Macintosh machines at a fraction of the price.  Or to an IBM
   styled machine, in order to take advantage of all the hardware options
   available, yet having an EFFECTIVE multasker, instead of being stuck with
   OS/2.

10.  That you had a powerful environment on which you could write a similar
   environment, (but with all your own improvements, of course), and compile
   the new environment and have a system of your very own, with no royalties
   owed to anyone?  (Perhaps for your own system to be manufactured and sold.)

11.  To have the ability to implement other languages, such as BASIC, LISP,
   Pascal, Prolog simply and efficiently?

In Forth, you can move about freely.  There is no "black box" compiler to
shackle you with unnecessary restraints.  No restriction to predefined data
structures.  You cannot get lost in GOTOs or jumps because Forth neither has
nor needs them.

Forth assumes you know what you are doing, and often how you do it is implicit.


    Personal Experience

Before I knew of the existance of Forth I knew I would have to have a language
that was infinitely extensible, and selfcompiling to do the things I wanted to
do.  When I learned what Forth was, it was like manna from heaven.

With systems such as OS9 having some of the advantages of Forth, and excellent
file handling, and with the availability of a powerful text editor such as
TSEdit, a person has a very effective system for gathering textual data
piecemeal and editing it.

But in using such a system, I have had to program around deficiencies of other
languages, been so hampered in reaching the hardware functions of the machine,
that some applications that should have been done were not practical to tackle,
(because of time restraints) and as a result been forced to use software for
which we haven't the source.  And so have been unable to adapt it exactly to
our needs, or add enhancements and upgrades that we should have had.

So, I am FORCED to incorporate the advantages of OS9 into Forth, as I can no
longer do without Forth's other, inherent advantages.

For a somewhat different experience, you might want to read Doug Hoffman's file
"NOVICE.TXT" in DL 1 at ForthSIG. (g forth.)   It's ASCII and you can REAd it,
though ACCESS thinks it's binary.


    What is Forth?

Forth is an infinitely extensible metacompilable language/operating system in
which subroutining is inherent.  (Metacompilable is a Forth term meaning it can
compile new versions of itself from source)

The stack's use is direct and largely automatic, and you can directly
manipulate it.

Though most implementations are sparse from an applications viewpoint, (though
I know of none that do not include an editor and assembler), it is so trivial
to extend it, that you can relatively easily write a LISP or BASIC interpreter,
C compiler, or a Prolog extension.  (I have seen most of these in sigs or
elsewhere.)

Since Forth is so compact, (it compiles to only subroutine addresses), and so
fast, (though slower than Machine Language to do exactly the same operations,
practically it's often faster, because of the better organization of the
functional blocks), and it can duplicate the power of any existing language, as
well as any you dream up that are MORE powerful, it's hard to deny that Forth
can be the MOST powerful language there is.  As a practical matter, complete
control is in the programmer's hands, so the extensions will be just as bad as
the programmer forces them to be!  (grin)

On the other hand, you don't have to say "stupid compiler writer!  Why didn't
he do it THIS way?!".  You can just recompile the whole system to suit
yourself!  Good idea to, because that way, it is your own system. to sell as an
application, developmment system, arcade game, or whatever, with no royalties
owed to anyone, and as a complete standalone system.


    Different Installations

It is also easily transportable.  You can redefine the primitives for the new
cpu, and recompile it, with all the resources of the present system at hand.

And because of the small number of necessary primitives, and of the extreme
modularity and interactive method of programming this allows, you will not
believe how easy such a port is until you see it!


    Examples

You may know that the RSdos BASIC PALETTE command (for the Coco) takes a slot
number (0-15) and puts a color value (0-63) into it.  The zero slot's hardware
address is 65456.  So I defined a PALETTE command in Forth thusly:

  : PAL -80 + C! ;

:  is a word called Colon, and is the most commonly used compiler.  It enters
the following word (a word is a group of non-space characters bounded by
spaces, in this case PAL), into the dictionary, and compiles the addresses of
the following words, (which normally must have already been defined), into the
dictionary as its definition.

-80 is the signed 16 bit integer equivalent of 65456.  Mention of a number puts
it on the stack.

+ takes the 2 top stack entries and adds them, leaving the result on top of the
stack.

! is pronounced "store".  It takes the second stack item and stores it in the
address on top of the stack.  But it stores SIXTEEN bit values.  In this case
we only want to store 1 byte, so we use Cstore, C being for "character".  Of
course C! is a different word from !.

; terminates all definitions started with :.

So now instead of PALETTE8,38 as I would use in basic, I can do 38 8 PAL.

38 pushes 38 on the stack.

8 pushes on the 8.

PAL first takes the top item and adds it and 65456 to give the address of slot
8, then stores 38 (second stack item) into one byte at that address.  And all
of a sudden, your text is orange.  (grin)

To make this command "system independent", you could first define a constant,
SL0T, thusly:

 65456 CONSTANT SL0T

(Constant is a compiling word that compiles...You got it, Constants!  (grin))

  Then define PAL thusly:

    : PAL SL0T + C! ;

That way, only SL0T would have to be changed for another system.  All system
dependent values could be stored in a single place, and so be easy to set up
for a different system.

Here's an edited example of the procedure for installing a rewritten primitive,
as explained by my friend Bob McIsaac:
--------------
 ' <EMIT> DUMP ..display code being used.
  You can figure a new version then install the hex code
using:
 CREATE EMIT NNNN , NNNN , NNNN , NEXT SMUDGE
  If it works then install it:-
 ' EMIT ' <EMIT> CFA ! FREEZE
  This works because the code field address of a word always
points to executable code and this can be anywhere in
memory.
---------------

In this example:

A dictionary header is made up like this:  Up to the first 31 bytes are the
NAME FIELD.  Next 2 bytes are the LINK FIELD, which points to the previously
defined word.

Next 2 bytes are the CODE FIELD, and point to executable code.  (The following
parameter field, if the word is a primitive.)  The remaining bytes are the
PARAMETER FIELD, which may contain executable code, addresses of other words,
variable storage, constant storage, tables, or what have you.

' (pronounced "tick") puts the PFA (Parameter Field Address) of the word
following it, on the stack.

DUMP gives a hex dump starting at the address on the stack.

CREATE creates a dictionary header for the word following it, in which the 1st
character is altered (smudged, by flipping a bit) so that it can't be found,
(while it is being defined).

, (Comma) Inserts the 16 bit value on top the stack at the current end of the
dictionary, and bumps the dictionary pointer 16 bits, (to the NEW end of
dictionary).

NEXT puts code in place for a "return" for the virtual Forth machine.

SMUDGE flips the flipped bit in the altered letter of the keyword, so that
actually, in this case, it's working more like an "unsmudge".  (grin)

CFA takes a PFA and converts it to a CFA (Code Field Address).  In this case,
the PFA of <EMIT> is converted to its CFA

!  Takes the second stack item (in this case, the PFA of EMIT) and stores it in
16 bits at the address on top of the stack, (in this case, the CFA of <EMIT>).

FREEZE sets the system so that it permanently recognizes this installation.


    Small Concept= Large Capability

Just a few additional concepts give you a great deal of added power.
Understanding "Compile time" and "Run time" behaviors of words, and "Compiling"
words, allows you to do things in the most direct way possible.

The "Reverse Polish Notation" use of the stack allows elimination of nearly all
other local variables.

I find Forth the easiest language in which to conceptualize a task.  Many
procedures that would not be trivial in any OTHER design of language, can be
programed in Forth out of hand.  Each part of the problem can always be
programmed seperately, as a preliminary word to the final word that does the
whole job.  Also you can start out with a word that just handles limited
conditions, and keep adding new functions to it as you elaborate on the
problem.

If you choose word names carefully, Forth is self documenting; also you can add
comments inside (or outside, of course) the definition.


    Grand Scale Programming

I have talked about designing or redesigning whole systems, for customization,
or porting to new hardware, and I expect it sounds like something that someone
might spend months, or maybe even years doing, but it more likely would take
you only a matter of days, because:

1. Forth systems tend to be very small.

2. You usually have the tools to do things in the most direct way possible.
   When you don't, you can MAKE them.

3. The combination of interactive programming with very small modules which are
   all subroutines usable individually, allows you to very efficiently
   "snowball" the power of your code.  In other words, though in any language a
   good programmer tries to write code whose power increases geometrically with
   the amount of code he writes, Forth was designed to allow you to do this
   very efficiently.

4. The modularity, interactivity, use of subroutines by naming them, as well as
   automatic stack use, makes debugging a breeze!


    Use

You can code interactively, at the terminal, to test things, but then for real
work, you enter the editor, and edit scripts or source onto disk.

Then you can take input from disk with a LOAD command, and do execution and
compiling directly from disk (until your file gives the command to take input
from terminal).

Forth can accomplish everything OS9 or Unix can, more simply.


    My plans

I've always wanted to write my own OS because I eventually wanted to put out my
own hardware, and wanted complete control of maintenance and no royalties.
There are many PD Forths, and Forth workalikes out there to build upon.

The system I want to develop now would include "Universal Random Block Access",
or URBA which means the ability to access all common disk formats, (Mac, MSdos,
Amiga, OS9, Unix, RSdos, CPM, ProDOS, CDOS, etc.)  Each format description
would be contained in a "DOS Descriptor Block" data structure, and if a new
format became popular, you could just add another DDB.  With additional device
descriptors, and drivers, you could access WORMs, and VHS, etc.

Naturally it will have multitasking, and I want to add all the most useful
commands of OS9 and Unix.  Of course it will always have the advantage of being
a programming language as well as an OS, over OS9 and Unix.


    Your Application

Although there are versions that run on top of OS9, Flex, CPM, MSdos,
etc., etc, to get the greatest advantages, you need Forth on the bottom!


    Availability on CIS

Put your checkbook away!  You can get versions of Forth for the popular CPUs
for down-load time:

    6809

The TIL09 system is on CocoSIG (go coco), in "Languages and Op.  Systems" Lib.
It makes ROM calls on the Tandy Color Computer.

  Here is a list of necessary files:
    TIL09.DOC   and
    M4TH.DOC    Describe operation and capabilities of TIL09.
    TEDIT.DOC   Describes editor use, and other necessary commands
                   imbedded in the editor.
    TILBUG.4TH  Bug fixes.
    TIL09.GLO   System glossary.
    TILASM.DOC  Overview of assembler.
    TIL09.BIN   Executable system.  From BASIC, do   LOADM"TIL09":EXEC.
                  Uses logical sector/block disk access.
    TILDOS.ARC  TILDOS uses RSDOS disk files. Instructions are
                   included.
    META1.BIN   and
    META2.BIN   are source for TIL09.
    TDCMP.BIN   is source for the metacompiler/decompiler.
    TEDIT.BIN   is the source for the editor.
    TILASM.4TH  source for the assembler.

    68000

Do a go clm332 to get to Computer Languages Magazine's forum, and there, in the
Forth library you can find:

    README.68K  installation instructions.
    F83-68.BIN  the executable Forth system. (Uses CPM disk access.)
    KER68K.SCR  source, necessary for adapting the system and
                helpful in understanding it.
    META68.SCR  source for the metacompiler, n case you want to alter the
                system, or make a completely new one.
    UTL68K.SCR  source for utilities.

Ataripro forum has basically the same forth as F83-68K, but different disk
access extensions for a non CP/M Forth.
    F83.TOS     The Atari ST version of Forth-83.  Includes some Atari xbios
                functions.
    KERNEL.BLK  Kernel source.
    KERNEL.TOS  The Forth kernel used for
                extending F83.
    META.BLK    The F83 meta-compiler.
    TRAPS.BLK   Atari xbios functions
    F83KER.ARC  and
    F83BLK.ARC  Sources for full blown Forth'83 and metacompiling for the Atari
                ST.
    CPU68.BLK   Assembler and low-level routines used by the debugger and
                multi-tasker.
    EXTEND.BLK  Extensions source.

    8086

  Also in CLM's Forth Library:

    README.PC   Dox for MS-DOS Forth.
    CMD4TH.BIN  IBM-PC dedicated Forth. (Does NOT go thru PC-DOS)
    F83-86.BIN  DOES go thru PC/MS-DOS.
    KER-86.SCR  System source.
    CPU-86.SCR  Assembler source.
    META86.SCR  Metacompiler source.

    8080

  Also in CLM's Forth Library:

    README.80    Documentation
    KERNAL.SCR   System source. (CPM80)
    F83-80.BIN   Executable system.(CPM80)


    Learning Forth

   "Starting Forth" by Leo Brodie: I'd recommend this for a first text.
    TIL09.GLO: This glossary is in CocoSIGs DL9.  Maybe not Forth '83 de
               rigueur, but it is helpful.
   "The Forth '83 Standard": The entire text for this is available in the
                             Forth forum, (g forth), in DL 2, as FORTH-.DOC.
    NOVICE.TXT: Is in DL 1 in ForthSIG.  You might want to read this file for
                the experiences of a beginner, in hopes of avoiding his
                frustrations.   Dispite the warning that it is binary, you can
                do a REAd on it.
    4THRES.TX0 (Forth resorce): This reference file is in Forth library in CLM
                (g clm332)....  You will find FIG's address in here.

We are planning a Forth workshop in CocoSIG.  Anyone interested may contact me
for the schedule.

Also, if anyone knows of other live "Forth Introductions", I'll appreciate
hearing of them.


    Social Aspects

There are people, some of whom are pretty good programmers, that consider Forth
a "Cult" language.  I've tried to figure why this is so, (*I* don't feel like a
cultist.(grin)), and so far I've come up with these possibilities:

1. Forth IS after all fundamentally "different" from any other language.
   (Despite its similarity to LISP.)

2. Once some people realize how much they can accomplish with Forth, they may
   get overexcited, and sound as though they have gone overboard!
   (Hehe..couldn't happen to ME!)

3. I think it likely that Forth is better than what they (the people that call
   it a "cult" language) are used to, and maybe, for whatever reason, they
   would rather not find that out!  (grin)

4. Though Forth tends to attract good programmers (The best!), it also
   attracts a few poor ones.  (I once saw a guy use a whole screen to define a
   single primitive (grin).)  Such a programmer is not likely to present
   Forth to a newcomer in its best light.  Also if the newcomer is himself a
   fairly good programmer, he's likely to figure that if his less capable
   friend thinks well of a language, it's probably a dud!  <Hehe> So, then, if
   he hears the enthusiasm of someone who really knows and uses the potential
   of Forth somewhere near its fullest, he's likely to attribute such
   enthusiasm to "cultism".  (grin).



    Problems

 Plex or contact me as follows:
  Giles Spruill 73347,2651
  Advanced Automation, Inc.
  1217 N.E. Miami Ct., Suite 6
  Miami, FL 33132
  Ph# (305) 371-6408

I would also appreciate any advice that would help make this file better.
